/*******************************************************************************
  ProcessChecker Demo
  Example submitted by David Clegg

  Form showing a brief description about the ProcessChecker application.
*******************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;

namespace ProcessChecker
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class AboutForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label lblVersion;
		private System.Windows.Forms.Label lblRelease;
		private System.Windows.Forms.Label lblBuild;
		private System.Windows.Forms.PictureBox pbLogo;
		private System.Windows.Forms.Label lblDescription;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;

		public AboutForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(AboutForm));
			this.btnClose = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.lblVersion = new System.Windows.Forms.Label();
			this.lblRelease = new System.Windows.Forms.Label();
			this.lblBuild = new System.Windows.Forms.Label();
			this.pbLogo = new System.Windows.Forms.PictureBox();
			this.lblDescription = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			//
			// btnClose
			//
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnClose.Location = new System.Drawing.Point(208, 232);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 0;
			this.btnClose.Text = "Close";
			//
			// label1
			//
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(128, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(120, 14);
			this.label1.TabIndex = 1;
			this.label1.Text = "Process Checker";
			//
			// lblVersion
			//
			this.lblVersion.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblVersion.Location = new System.Drawing.Point(128, 26);
			this.lblVersion.Name = "lblVersion";
			this.lblVersion.Size = new System.Drawing.Size(104, 14);
			this.lblVersion.TabIndex = 3;
			this.lblVersion.Text = "lblVersion";
			//
			// lblRelease
			//
			this.lblRelease.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblRelease.Location = new System.Drawing.Point(128, 44);
			this.lblRelease.Name = "lblRelease";
			this.lblRelease.Size = new System.Drawing.Size(104, 14);
			this.lblRelease.TabIndex = 5;
			this.lblRelease.Text = "lblRelease";
			//
			// lblBuild
			//
			this.lblBuild.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblBuild.Location = new System.Drawing.Point(128, 62);
			this.lblBuild.Name = "lblBuild";
			this.lblBuild.Size = new System.Drawing.Size(104, 16);
			this.lblBuild.TabIndex = 7;
			this.lblBuild.Text = "lblBuild";
			//
			// pbLogo
			//
			this.pbLogo.Image = ((System.Drawing.Image)(resources.GetObject("pbLogo.Image")));
			this.pbLogo.Location = new System.Drawing.Point(16, 8);
			this.pbLogo.Name = "pbLogo";
			this.pbLogo.Size = new System.Drawing.Size(72, 72);
			this.pbLogo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pbLogo.TabIndex = 8;
			this.pbLogo.TabStop = false;
			//
			// lblDescription
			//
			this.lblDescription.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblDescription.Location = new System.Drawing.Point(16, 96);
			this.lblDescription.Name = "lblDescription";
			this.lblDescription.Size = new System.Drawing.Size(264, 104);
			this.lblDescription.TabIndex = 9;
			this.lblDescription.Text = "lblDescription";
			//
			// label2
			//
			this.label2.Location = new System.Drawing.Point(8, 224);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(144, 16);
			this.label2.TabIndex = 10;
			this.label2.Text = "Written by David Clegg";
			//
			// label3
			//
			this.label3.Location = new System.Drawing.Point(8, 240);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(160, 16);
			this.label3.TabIndex = 11;
			this.label3.Text = "davidclegg@optusnet.com.au";
			//
			// AboutForm
			//
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 270);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.lblDescription);
			this.Controls.Add(this.pbLogo);
			this.Controls.Add(this.lblBuild);
			this.Controls.Add(this.lblRelease);
			this.Controls.Add(this.lblVersion);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.btnClose);
			this.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "AboutForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "About Process Checker...";
			this.Load += new System.EventHandler(this.AboutForm_Load);
			this.ResumeLayout(false);
		}

		#endregion

		public static DialogResult ShowAboutForm() {
			AboutForm aboutForm = new AboutForm();
			return aboutForm.ShowDialog();
		}

		private void AboutForm_Load(object sender, System.EventArgs e) {
			PopulateVersionLabels();
			MakeImageTransparent();
		}

		/// <summary>
		/// Populate the labels on the About box from the File Version Information
		/// resource
		/// </summary>
		private void PopulateVersionLabels() {
			FileVersionInfo fvi = FileVersionInfo.GetVersionInfo(Application.ExecutablePath);
			lblVersion.Text = string.Format("Version {0}.{1}",fvi.ProductMajorPart, fvi.ProductMinorPart);
			lblRelease.Text = string.Format("Release {0}", fvi.ProductBuildPart);
			lblBuild.Text = string.Format("Build {0}", fvi.ProductPrivatePart);
			lblDescription.Text = fvi.Comments;
		}
		/// <summary>
		/// Until I can figure out how to make the background transparent at
		/// design time...
		/// </summary>
		private void MakeImageTransparent() {
			((Bitmap)pbLogo.Image).MakeTransparent();
		}

	}
}
